<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use App\Http\Controllers\API\BaseController as BaseController;
use Illuminate\Support\Facades\Auth;
use Validator;
use App\Models\User;
use App\Models\StudentInofModel;
use DB;
use Illuminate\Support\Facades\Mail;

class AppLoginController extends BaseController
{

    public function signin(Request $request)
    {

        if(Auth::attempt(['email' => $request->email, 'password' => $request->password])){
            $authUser = Auth::user();

            $fcm_id = request('fcm_reg_id');
            $app_id = request('app_id');
            $osVersion = request('os_version');
            $os_type = request('os_type');
            $app_version = request('app_version');
            $deviceModel = request('mobile_manufacture');
            $pkg_name = request('pkg_name');
            $FCM_REG_ID = Auth::user()->fcm_reg_id;

            $mobileAppsInfo = DB::table('sa_mobiapps')->select('maver_code')->where('mobiaps_id',$app_id)->where('mapps_name',$pkg_name)->first();


            if (!empty($fcm_id)) {
                if (!empty($FCM_REG_ID)) {
                    if ($fcm_id != $FCM_REG_ID) {
                        DB::table('users')->where('id', '=', Auth::user()->id)->update([
                            'fcm_reg_id' => $fcm_id,
                            //'maver_code' => $appVersionCode,
                            'os_version' => $osVersion,
                            'os_type'    => $os_type,
                            'mobile_manufacture' => $deviceModel,
                            'app_version' => $app_version,
                            'last_login' => date('d-M-Y h:i:s A')
                        ]);
                    }else{
                        DB::table('users')->where('id', '=', Auth::user()->id)->update([
                            'fcm_reg_id' => $fcm_id,
                            //'maver_code' => $appVersionCode,
                            'os_version' => $osVersion,
                            'os_type'    => $os_type,
                            'mobile_manufacture' => $deviceModel,
                            'app_version' => $app_version,
                            'last_login' => date('d-M-Y h:i:s A')
                        ]);
                    }
                }
            }

            $success['token'] =  $authUser->createToken('MyAuthApp')->plainTextToken;
            $success['name'] =  $authUser->name;
            $success['maver_code'] =  $mobileAppsInfo->maver_code;

            $success['user_info'] = DB::table('stu_students_information as dt1')
                ->leftJoin('sa_lookup_data as dt2', 'dt1.gender', '=', 'dt2.LOOKUP_DATA_ID')
                ->leftJoin('sa_lookup_data as dt3', 'dt1.department', '=', 'dt3.LOOKUP_DATA_ID')
                ->leftJoin('sa_lookup_data as dt4', 'dt1.course_type', '=', 'dt4.LOOKUP_DATA_ID')
                ->leftJoin('sa_lookup_data as dt5', 'dt1.course_name', '=', 'dt5.LOOKUP_DATA_ID')
                ->leftJoin('sa_lookup_data as dt6', 'dt1.session_years', '=', 'dt6.LOOKUP_DATA_ID')
                ->leftJoin('sa_lookup_data as dt7', 'dt1.batch_no', '=', 'dt7.LOOKUP_DATA_ID')
                ->Where('dt1.active_status', '=',1)
                ->where('dt1.student_id',$authUser->student_id)
                ->select('dt1.student_id','dt1.students_name','dt1.stu_id','dt1.date_of_birth','dt1.students_image','dt1.students_signature','dt1.department','dt1.course_type','dt1.course_name','dt2.LOOKUP_DATA_NAME AS GENDER','dt3.LOOKUP_DATA_NAME AS DEPARTMENT','dt4.LOOKUP_DATA_NAME AS COURSE_TYPE','dt5.LOOKUP_DATA_NAME AS COURSE_NAME','dt6.LOOKUP_DATA_NAME AS SESSION_YEAR','dt7.LOOKUP_DATA_NAME AS BATCH')
                ->first();

            $success['student_image'] = DB::selectOne(DB::raw("select CONCAT('uploads/student_information/', students_image) AS image_location from stu_students_information where student_id = $authUser->student_id"));
            $success['students_signature'] = DB::selectOne(DB::raw("select CONCAT('uploads/student_information/signature/', students_signature) AS signature_location from stu_students_information where student_id = $authUser->student_id"));


           // return $this->sendResponse($success, 'User signed in');

            return response()->json([
                "success" => true,
                "message" => "User signed in successfully.",
                "data" => $success
            ]);
        }
        else{
            return $this->sendError('Unauthorised.', ['error'=>'Unauthorised']);
        }
    }

    public function userRegister(Request $request){
        $input = $request->all();
        $employeeNumber = $input['employeeNumber'];
        $employeeName = $input['employeeName'];
        $department = $input['department'];
        $designation = $input['designation'];
        $religion = $input['religion'];
        $loaction = $input['loaction'];
        $org_id = $input['org_id'];
        $cardNo = $input['cardNo'];
        $bloodGroup = $input['bloodGroup'];
        $email = $input['email'];
        $mobile = $input['mobile'];
        $password = $input['password'];

        $jobId = $input['jobId'];
        $userLeveId = '';
        if($jobId =='70'){
            $userLeveId .='18';
        }else if($department =="HR & Administration" && $jobId !='70'){
            $userLeveId .='16';
        }else{
            $userLeveId .='7';
        }

        $maxId = DB::table('users')->max('id')+1;

        $registerId = DB::table('users')->insertGetId([
            "employee_number"=>$employeeNumber,
            "name"=>$employeeName,
            "email"=>$employeeNumber,
            "email_address"=>$email,
            "department_id"=>0,
            "designation"=>0,
            "department_name"=>$department,
            "designation_name"=>$designation,
            "email_address"=>$email,
            "contact_no"=>$mobile,
            "org_id"=>$org_id,
            "loaction"=>$loaction,
            "religion"=>$religion,
            "USERGRP_ID"=>$department =="HR & Administration"? "2":"3",
            //"USERLVL_ID"=>$department =="HR & Administration"? "16":"7",
            "USERLVL_ID"=>$userLeveId,
            "password"=>bcrypt($password),
            "active_status"=>1,
            "request_from"=>1,
        ]);
        
        // designation table create
        // check designation exist or not
        $desigCheck = DB::table('set_designation')->select('id')->where('designation_name',$designation)->first();
       
        $desigId ="";
        if(empty($desigCheck)){
            $desigId .= DB::table('set_designation')->insertGetId([
                'designation_name' => $designation,
                'active_status' => 1
            ]);
        }

        $deptId = DB::table('set_department')->select('id')->where('department_name',$department)->first()->id;

       

        $employees = DB::table('npoly_employees')->insert([
            "user_serial_no"=>DB::table('npoly_employees')->max('user_serial_no')+1,
            "employee_name"=>$employeeName,
            "employee_number"=>$employeeNumber,
            "email"=>$email,
            "card_no"=>$cardNo,
            "mobile_no"=>$mobile,
            "department_id"=>$deptId,
            "designation_id"=>$desigCheck ?$desigCheck->id:$desigId,
            "blood_group"=>$bloodGroup,
            "active_status"=>1,
            "created_at"=>date('Y-m-d H:i:s A'),
        ]);

        $employeeId = DB::table('npoly_employees')->select('employee_id')->where('employee_number',$employeeNumber)->first();

        $updateUser = DB::table('users')->where('id',$registerId)->update([
            "department_id"=>$deptId,
            "employee_id"=>$employeeId->employee_id,
            "designation"=>$desigCheck ?$desigCheck->id:$desigId,
        ]);

        // $data['employee_name'] =$employeeName; 
        // $data['department'] =$department; 
        // $data['designation'] =$designation; 
        // $data['form_name'] = 'User';
        // $data['title'] = 'User Create';

        // // user request mail to respect person
        // $data['form_email'] = 'ticket@nationalpolymer.net';
        // $sent = Mail::send('emails.user_register_mail', $data, function ($m) use ($data) {
        //     $m->from($data['form_email'], $data['form_name']);
        //     //$m->to($data['support_user_mail']);
        //     $m->to(['azam.ali@nationalpolymer.net']);
        //     $m->subject($data['title']);
        // });


        return response()->json([
            "success" => true,
            "message" => "User register  successfully.",
        ]);



    }

   public function updatePassword(Request $request){
        $input = $request->all();
        $employeeNumber = $input['employeeNumber'];
        $password = $input['password'];

        $updateUser = DB::table('users')->where('employee_number',$employeeNumber)->update([
           "password"=>bcrypt($password),
        ]);
         return response()->json([
            "success" => true,
            "message" => "User Password successfully.",
        ]);
   }

    public function getUserInfo(){
        $userInfo = DB::table('users')->select('*')->get();

        return response()->json([
            "success" => true,
            "message" => "Data get successfully.",
            "data" => $userInfo
        ],200);
    }

    public function getModuleScreen(){
        $userInfo = DB::table('users')->select('USERGRP_ID','USERLVL_ID')->where('employee_number',6586)->first();
        $module = DB::select("SELECT DISTINCT sl.module_id,m.module_name as drawer FROM mobile_uglw_mlink as sl,mobile_module as m
        WHERE sl.MODULE_ID = m.MODULE_ID
        AND USERGRP_ID = $userInfo->USERGRP_ID AND UG_LEVEL_ID =$userInfo->USERLVL_ID AND sl.STATUS=1 ORDER BY sl.module_id");
       //$module = DB::select("select module_id, module_name as drawer from mobile_module where active_status = 1");

       foreach( $module as $key => $mod ) {

        //$module[ $key]->stack = DB::table('mobile_module_screen')->select('screen_name')->where('module_id',$adress->module_id)->get();
        $module[ $key]->stack = DB::select("SELECT sl.screen_id, ms.screen_name FROM mobile_uglw_mlink as sl,mobile_module_screen as ms
                                            WHERE sl.screen_id = ms.screen_id
                                            AND USERGRP_ID = $userInfo->USERGRP_ID 
                                            AND UG_LEVEL_ID =$userInfo->USERLVL_ID
                                            AND sl.module_id =$mod->module_id
                                            AND sl.STATUS=1");
   
   }


        return response()->json([
            "success" => true,
            "message" => "Data get successfully.",
            "data" => $module
        ],200);
    }

    public function getModuleScreenByUserCheck(Request $request){
        $input = $request->all();
        $employeeNumber = $input['employeeNumber'];

       $userInfo = DB::table('users')->select('USERGRP_ID','USERLVL_ID','id')->where('employee_number',$employeeNumber)->first();
       //dd($userInfo);
        $module = DB::select("SELECT DISTINCT sl.module_id,m.module_name as drawer FROM mobile_uglw_mlink as sl,mobile_module as m
        WHERE sl.MODULE_ID = m.MODULE_ID
        AND USERGRP_ID = $userInfo->USERGRP_ID AND UG_LEVEL_ID =$userInfo->USERLVL_ID AND sl.STATUS=1 and m.active_status=1 ORDER BY sl.module_id");
       //$module = DB::select("select module_id, module_name as drawer from mobile_module where active_status = 1");

    //    foreach( $module as $key => $mod ) {
    //     $module[ $key]->stack = DB::select("SELECT sl.screen_id, ms.screen_name FROM mobile_uglw_mlink as sl,mobile_module_screen as ms
    //                                         WHERE sl.screen_id = ms.screen_id
    //                                         AND USERGRP_ID = $userInfo->USERGRP_ID 
    //                                         AND UG_LEVEL_ID =$userInfo->USERLVL_ID
    //                                         AND sl.module_id =$mod->module_id
    //                                         AND sl.STATUS=1");
   
    //     }

    $stack = DB::select("SELECT sl.screen_id, ms.screen_name FROM mobile_uglw_mlink as sl,mobile_module_screen as ms
                                            WHERE sl.screen_id = ms.screen_id
                                            AND USERGRP_ID = $userInfo->USERGRP_ID 
                                            AND UG_LEVEL_ID =$userInfo->USERLVL_ID
                                            AND sl.STATUS=1");

                                           
       /* $datetime1 = date_create('2024-06-12');
        $datetime2 = date_create(date('Y-m-d'));
       
        // Calculates the difference between DateTime objects
        $diff = date_diff($datetime1, $datetime2);
       
        // Printing result in years & months format
         $diffDays =  $diff->format("%r%a");
         if($diffDays > 15){
            $row = DB::table('company_handbook')->where('employee_number',$employeeNumber)->first();
            if($row){
                $count = collect((array) $row)->filter(function ($value) {
                    return $value == 1;
                })->count();
                if($count < 9){
                    $changeLoginStatus = DB::connection('oracle')->table('XX_TKT_OFF_APP_USERS')
                    ->where('employee_number',$employeeNumber)
                    ->update([
                    'LOGIN_STATUS'=>0
                    ]);
                    $loginStatus = DB::table('users')->where('employee_number',$employeeNumber)->update([
                        'login_status'=>0
                    ]);
                    return response()->json([
                        "drawer" => [],
                        "stact" =>[],
                        "userId" => $userInfo->id
                    ],200);
                }
            }else{
                $changeLoginStatus = DB::connection('oracle')->table('XX_TKT_OFF_APP_USERS')
                ->where('employee_number',$employeeNumber)
                ->update([
                'LOGIN_STATUS'=>0
                ]);
                $loginStatus = DB::table('users')->where('employee_number',$employeeNumber)->update([
                    'login_status'=>0
                ]);
            return response()->json([
                "drawer" => [],
                "stact" =>[],
                "userId" => $userInfo->id
            ],200);
            }
         }*/


        return response()->json([
            //"success" => true,
           // "message" => "Data get successfully.",
            "drawer" => $module,
            "stact" => $stack,
            "userId" => $userInfo->id
        ],200);
    }
    public function getModuleScreenByUser(Request $request){
        $input = $request->all();
        $employeeNumber = $input['employeeNumber'];

       $userInfo = DB::table('users')->select('USERGRP_ID','USERLVL_ID','id')->where('employee_number',$employeeNumber)->first();
        $module = DB::select("SELECT DISTINCT sl.module_id,m.module_name as drawer FROM mobile_uglw_mlink as sl,mobile_module as m
        WHERE sl.MODULE_ID = m.MODULE_ID
        AND USERGRP_ID = $userInfo->USERGRP_ID AND UG_LEVEL_ID =$userInfo->USERLVL_ID AND sl.STATUS=1 and m.active_status=1 ORDER BY sl.module_id");
       //$module = DB::select("select module_id, module_name as drawer from mobile_module where active_status = 1");

    //    foreach( $module as $key => $mod ) {
    //     $module[ $key]->stack = DB::select("SELECT sl.screen_id, ms.screen_name FROM mobile_uglw_mlink as sl,mobile_module_screen as ms
    //                                         WHERE sl.screen_id = ms.screen_id
    //                                         AND USERGRP_ID = $userInfo->USERGRP_ID 
    //                                         AND UG_LEVEL_ID =$userInfo->USERLVL_ID
    //                                         AND sl.module_id =$mod->module_id
    //                                         AND sl.STATUS=1");
   
    //     }

    $stack = DB::select("SELECT sl.screen_id, ms.screen_name FROM mobile_uglw_mlink as sl,mobile_module_screen as ms
                                            WHERE sl.screen_id = ms.screen_id
                                            AND USERGRP_ID = $userInfo->USERGRP_ID 
                                            AND UG_LEVEL_ID =$userInfo->USERLVL_ID
                                            AND sl.STATUS=1");

                                           
       /* $datetime1 = date_create('2024-06-12');
        $datetime2 = date_create(date('Y-m-d'));
       
        // Calculates the difference between DateTime objects
        $diff = date_diff($datetime1, $datetime2);
       
        // Printing result in years & months format
         $diffDays =  $diff->format("%r%a");
         if($diffDays > 15){
            $row = DB::table('company_handbook')->where('employee_number',$employeeNumber)->first();
            if($row){
                $count = collect((array) $row)->filter(function ($value) {
                    return $value == 1;
                })->count();
                if($count < 9){
                    $changeLoginStatus = DB::connection('oracle')->table('XX_TKT_OFF_APP_USERS')
                    ->where('employee_number',$employeeNumber)
                    ->update([
                    'LOGIN_STATUS'=>0
                    ]);
                    $loginStatus = DB::table('users')->where('employee_number',$employeeNumber)->update([
                        'login_status'=>0
                    ]);
                    return response()->json([
                        "drawer" => [],
                        "stact" =>[],
                        "userId" => $userInfo->id
                    ],200);
                }
            }else{
                $changeLoginStatus = DB::connection('oracle')->table('XX_TKT_OFF_APP_USERS')
                ->where('employee_number',$employeeNumber)
                ->update([
                'LOGIN_STATUS'=>0
                ]);
                $loginStatus = DB::table('users')->where('employee_number',$employeeNumber)->update([
                    'login_status'=>0
                ]);
            return response()->json([
                "drawer" => [],
                "stact" =>[],
                "userId" => $userInfo->id
            ],200);
            }
         }*/


        return response()->json([
            //"success" => true,
           // "message" => "Data get successfully.",
            "drawer" => $module,
            "stact" => $stack,
            "userId" => $userInfo->id
        ],200);
    }

    public function signups(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required|email',
            'password' => 'required',
            'confirm_password' => 'required|same:password',
        ]);

        if($validator->fails()){
            return $this->sendError('Error validation', $validator->errors());
        }

        $input = $request->all();
        $input['password'] = bcrypt($input['password']);
        $user = User::create($input);
        $success['token'] =  $user->createToken('MyAuthApp')->plainTextToken;
        $success['name'] =  $user->name;

        return $this->sendResponse($success, 'User created successfully.');
    }
  
  
    public function sendNotification(Request $request){
        $input = $request->all();
        /*$url = ' http://192.168.251.39:3000/api/v1/mobile/auth/notify';
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($curl);
        curl_close($curl);*/
        $url = 'http://192.168.251.39:3000/api/v1/mobile/auth/notify';

        // The data to send in the POST request
        $data = array(
            'employee_number' => '4200'
        );

        // Convert the data array to JSON
        $jsonData = json_encode($data);

        // Initialize cURL session
        $curl = curl_init($url);

    // Set the cURL options
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_POST, true); // Set the request method to POST
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_HEADER, false);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonData); // Attach the JSON data
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Content-Length: ' . strlen($jsonData)
            ));

            // Execute the POST request
            $response = curl_exec($curl);

            // Check for errors
            if (curl_errno($curl)) {
                echo 'Error:' . curl_error($curl);
            } else {
                // Print the response from the server
                echo 'Response from server: ' . $response;
            }

            // Close cURL session
            curl_close($curl);
        }
}